/*
 * Decompiled with CFR 0.152.
 */
package com.khalilganiga.AutoClicker;

import java.awt.AWTException;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Robot;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.FileHandler;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class AutoClickerApp
extends JFrame {
    private Timer timer;
    final transient Logger logger = Logger.getLogger(AutoClickerApp.class.getName());
    private final JProgressBar progressBar;
    private final JTextField timerIntervalField = new JTextField("30", 5);
    private final JButton startButton;
    private final JButton stopButton;

    public AutoClickerApp() {
        this.initLogger();
        this.setTitle("Auto Clicker");
        this.setSize(400, 200);
        this.setDefaultCloseOperation(3);
        this.setResizable(false);
        this.startButton = new JButton("Start Auto Clicker");
        this.startButton.addActionListener(e -> this.startAutoClicker());
        this.stopButton = new JButton("Stop Auto Clicker");
        this.stopButton.setVisible(false);
        this.stopButton.addActionListener(e -> this.stopAutoClicker());
        JLabel timerLabel = new JLabel("Timer Interval (seconds): ");
        this.progressBar = new JProgressBar();
        this.progressBar.setStringPainted(true);
        this.progressBar.setForeground(new Color(144, 238, 144));
        JPanel buttonPanel = new JPanel(new FlowLayout());
        buttonPanel.add(this.startButton);
        buttonPanel.add(this.stopButton);
        JPanel inputPanel = new JPanel(new FlowLayout());
        inputPanel.add(timerLabel);
        inputPanel.add(this.timerIntervalField);
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(inputPanel);
        panel.add(buttonPanel);
        panel.add(this.progressBar);
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.add((Component)panel, "Center");
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> new AutoClickerApp().setVisible(true));
    }

    private void initLogger() {
        try {
            FileHandler fileHandler = new FileHandler("AutoClickerLog.log");
            SimpleFormatter formatter = new SimpleFormatter();
            fileHandler.setFormatter(formatter);
            this.logger.addHandler(fileHandler);
        }
        catch (Exception e) {
            this.logger.severe("Exception occurred in Logger initialization: " + e);
        }
    }

    private void startAutoClicker() {
        this.setActionButtons(false, true);
        final int interval = Integer.parseInt(this.timerIntervalField.getText());
        this.progressBar.setMaximum(interval);
        if (this.timer != null && this.timer.isRunning()) {
            this.timer.stop();
        }
        this.timer = new Timer(1000, new ActionListener(){
            int secondsRemaining;
            {
                this.secondsRemaining = interval;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                --this.secondsRemaining;
                AutoClickerApp.this.progressBar.setValue(interval - this.secondsRemaining);
                AutoClickerApp.this.progressBar.setString(this.secondsRemaining + " seconds remaining");
                if (this.secondsRemaining <= 0) {
                    AutoClickerApp.this.simulateMouseClick();
                    this.secondsRemaining = interval;
                }
            }
        });
        this.timer.setInitialDelay(0);
        this.timer.setDelay(1000);
        this.timer.start();
        this.timer.getActionListeners()[0].actionPerformed(null);
    }

    private void setActionButtons(boolean startFlag, boolean stopFlag) {
        this.startButton.setVisible(startFlag);
        this.stopButton.setVisible(stopFlag);
        this.timerIntervalField.setEditable(startFlag);
    }

    private void simulateMouseClick() {
        try {
            Robot robot = new Robot();
            robot.mousePress(1024);
            robot.mouseRelease(1024);
        }
        catch (AWTException e) {
            this.logger.severe("Error simulating mouse click: " + e.getMessage());
        }
    }

    private void stopAutoClicker() {
        this.setActionButtons(true, false);
        if (this.timer != null && this.timer.isRunning()) {
            this.timer.stop();
        }
        this.progressBar.setValue(0);
        this.progressBar.setString("Auto Clicker stopped");
    }
}

