/*
 * Decompiled with CFR 0.152.
 */
package com.khalilganiga.javadecompiler;

import com.khalilganiga.javadecompiler.Utils;
import com.strobel.decompiler.Decompiler;
import com.strobel.decompiler.PlainTextOutput;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import javax.swing.JProgressBar;
import javax.swing.SwingWorker;

public class DecompilationWorker
extends SwingWorker<Void, Integer> {
    private final String inputDirectoryPath;
    private final String outputDirectoryPath;
    private final JProgressBar progressBar;
    private int totalClassFiles;

    public DecompilationWorker(String inputDirectoryPath, String outputDirectoryPath, JProgressBar progressBar) {
        this.inputDirectoryPath = inputDirectoryPath;
        this.outputDirectoryPath = outputDirectoryPath;
        this.progressBar = progressBar;
    }

    @Override
    protected Void doInBackground() {
        File inputDir = new File(this.inputDirectoryPath);
        File outputDir = new File(this.outputDirectoryPath);
        if (!(inputDir.exists() && inputDir.isDirectory() && outputDir.exists())) {
            this.showInfoDialog("Invalid input or output directory", "Error");
            return null;
        }
        this.totalClassFiles = this.countClassFiles(inputDir);
        if (this.totalClassFiles == 0) {
            this.showInfoDialog("No class files found in the input directory", "Error");
            return null;
        }
        this.progressBar.setMaximum(this.totalClassFiles);
        this.processDirectory(inputDir, outputDir);
        this.progressBar.setValue(this.progressBar.getMaximum());
        this.showInfoDialog("Decompilation completed", "Success");
        return null;
    }

    private int countClassFiles(File dir) {
        int count = 0;
        File[] files = dir.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    count += this.countClassFiles(file);
                    continue;
                }
                if (!file.getName().endsWith(".class")) continue;
                ++count;
            }
        }
        return count;
    }

    private void processDirectory(File inputDir, File outputDir) {
        File[] files = inputDir.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    File newOutputDir = new File(outputDir, file.getName());
                    newOutputDir.mkdirs();
                    this.processDirectory(file, newOutputDir);
                    continue;
                }
                if (!file.getName().endsWith(".class")) continue;
                String relativePath = inputDir.toURI().relativize(file.toURI()).getPath();
                String outputFilePath = new File(outputDir, relativePath.replace(".class", ".java")).getAbsolutePath();
                this.decompileClassFile(file.getAbsolutePath(), outputFilePath);
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                this.publish(this.progressBar.getValue() + 1);
            }
        }
    }

    private void decompileClassFile(String absolutePath, String outputFilePath) {
        try {
            PlainTextOutput output = new PlainTextOutput();
            Decompiler.decompile(absolutePath, output);
            try (FileOutputStream fileOutputStream = new FileOutputStream(outputFilePath);){
                fileOutputStream.write(output.toString().getBytes());
            }
        }
        catch (IOException e) {
            Utils.showInfoDialog("Error during de-compilation: " + e.getMessage(), "Error");
        }
    }

    @Override
    protected void process(List<Integer> chunks) {
        for (int value : chunks) {
            this.progressBar.setValue(value);
        }
    }

    private void showInfoDialog(String message, String title) {
        Utils.showInfoDialog(message, title);
    }
}

