/*
 * Decompiled with CFR 0.152.
 */
package com.khalilganiga.javadecompiler;

import com.khalilganiga.javadecompiler.DecompilationWorker;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class DecompilerGUI
extends JFrame {
    private JTextField inputDirectoryField;
    private JTextField outputDirectoryField;
    private JProgressBar progressBar;
    private JButton runButton;

    public DecompilerGUI() {
        super("Java Decompiler By Khalil");
        this.initializeComponents();
    }

    private void initializeComponents() {
        this.setLayout(new BorderLayout());
        this.inputDirectoryField = new JTextField(30);
        JButton inputDirectoryButton = new JButton("Choose Input Directory");
        this.outputDirectoryField = new JTextField(30);
        JButton outputDirectoryButton = new JButton("Choose Output Directory");
        this.runButton = new JButton("Run");
        this.runButton.setEnabled(false);
        this.progressBar = new JProgressBar(0, 100);
        this.progressBar.setStringPainted(true);
        this.progressBar.setForeground(new Color(0, 128, 128));
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.insets = new Insets(5, 5, 5, 5);
        JLabel decompilerDescription = new JLabel("Decompile Java classes to readable code");
        decompilerDescription.setFont(new Font("Arial", 1, 16));
        decompilerDescription.setForeground(Color.BLACK);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 2;
        constraints.anchor = 10;
        panel.add((Component)decompilerDescription, constraints);
        constraints.gridwidth = 1;
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.anchor = 21;
        panel.add((Component)inputDirectoryButton, constraints);
        constraints.gridx = 0;
        constraints.gridy = 2;
        panel.add((Component)outputDirectoryButton, constraints);
        constraints.gridx = 0;
        constraints.gridy = 3;
        panel.add((Component)this.runButton, constraints);
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.gridheight = 1;
        constraints.fill = 2;
        panel.add((Component)this.inputDirectoryField, constraints);
        constraints.gridy = 2;
        panel.add((Component)this.outputDirectoryField, constraints);
        constraints.gridy = 3;
        constraints.anchor = 10;
        panel.add((Component)this.progressBar, constraints);
        int buttonWidth = Math.max(inputDirectoryButton.getPreferredSize().width, outputDirectoryButton.getPreferredSize().width);
        inputDirectoryButton.setPreferredSize(new Dimension(buttonWidth, inputDirectoryButton.getPreferredSize().height));
        outputDirectoryButton.setPreferredSize(new Dimension(buttonWidth, outputDirectoryButton.getPreferredSize().height));
        this.inputDirectoryField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                DecompilerGUI.this.updateRunButtonState();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                DecompilerGUI.this.updateRunButtonState();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                DecompilerGUI.this.updateRunButtonState();
            }
        });
        this.outputDirectoryField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                DecompilerGUI.this.updateRunButtonState();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                DecompilerGUI.this.updateRunButtonState();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                DecompilerGUI.this.updateRunButtonState();
            }
        });
        inputDirectoryButton.addActionListener(e -> this.chooseDirectory(this.inputDirectoryField));
        outputDirectoryButton.addActionListener(e -> this.chooseDirectory(this.outputDirectoryField));
        this.runButton.addActionListener(e -> this.runDecompiler());
        this.setDefaultCloseOperation(3);
        this.setSize(600, 200);
        this.setLocationRelativeTo(null);
        this.setVisible(true);
        this.setResizable(false);
        this.add((Component)panel, "Center");
    }

    private void updateRunButtonState() {
        boolean inputSet = !this.inputDirectoryField.getText().isEmpty();
        boolean outputSet = !this.outputDirectoryField.getText().isEmpty();
        this.runButton.setEnabled(inputSet && outputSet);
    }

    private void chooseDirectory(JTextField textField) {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileSelectionMode(1);
        int result = fileChooser.showOpenDialog(this);
        if (result == 0) {
            File selectedFile = fileChooser.getSelectedFile();
            textField.setText(selectedFile.getAbsolutePath());
        }
    }

    private void runDecompiler() {
        String inputDirectoryPath = this.inputDirectoryField.getText();
        String outputDirectoryPath = this.outputDirectoryField.getText();
        if (this.isValidDirectory(inputDirectoryPath) && this.isValidDirectory(outputDirectoryPath)) {
            this.progressBar.setValue(0);
            new DecompilationWorker(inputDirectoryPath, outputDirectoryPath, this.progressBar).execute();
        } else {
            this.showInfoDialog("Invalid input or output directory", "Error");
        }
    }

    private boolean isValidDirectory(String directoryPath) {
        File directory = new File(directoryPath);
        return directory.exists() && directory.isDirectory();
    }

    private void showInfoDialog(String message, String title) {
        JOptionPane.showMessageDialog(this, message, title, 1);
    }
}

